﻿<html>
	<head>
		<title>LassoSoft Tip of the Week - SOAP Examples</title>
		<style type="text/css">
			body { font-family: Verdana; font-size: 10px; width: 576px; }
			p,td,pre { font-family: Verdana; font-size: 10px; }
			th { font-family: Verdana; font-weight: bold; font-size: 10px; text-align: left; }
			h1 { font-family: Verdana; font-weight: bold; font-size: 15px; }
			hr { border: 2px solid #cccccc; }
			h1 a { text-decoration: none; color: black; }
			pre { margin: 3px 12px; }
		</style>
	</head>
	<body>
		<h2>JSON-RPC Examples</h2>

		<p><b>Remote JSON-RPC Call</b> - The following code makes a remote JSON-RPC call to the JavaScript O Lait test server.</p>
		
		<pre>[NoProcess][JSON_RPCCall: -host='http://jsolait.net/services/test.jsonrpc', -method='echo', -params=(array: 'Hello World!'), -id=1234][/NoProcess]</pre>
		
		<p>The results of the call are shown here:</p>
		
		<pre>-> [JSON_RPCCall: -host='http://jsolait.net/services/test.jsonrpc', -method='echo', -params=(array: 'Hello World!'), -id=1234]</pre>

		<p><b>Local JSON-RPC Call</b> - The following code defines a local "echo" procedure and calls it through JSON-RPC.</p>

		<pre>[NoProcess][define_tag: 'echo', -rpc, -required='value'][return: #value][/define_tag]</pre>
		<pre>[JSON_RPCCall: -method='echo', -params=(array: 'Hello World!'), -id=1234][/NoProcess]</pre>

		<p>The results of the call are shown here:</p>
		
		[define_tag: 'echo', -rpc, -required='value'][return: #value][/define_tag]
		<pre>-> [JSON_RPCCall: -method='echo', -params=(array: 'Hello World!'), -id=1234]</pre>

		<p>These examples are described in the following Tip of the Week:
		<br /><a href="http://www.lassosoft.com/Documentation/TotW/index.lasso?9319">
			http://www.lassosoft.com/Documentation/TotW/index.lasso?9319
		</a></p>
		
		<p>Copyright &copy; 2007 LassoSoft, LLC</p>

	</body>
</html>