<?LassoScript

	define_tag: 'encode_taglink', -required='value', -required='id';
		local: 'output' = #value;
		#output = (string_replaceregexp: #output, -find=' ?\\.\\.\\..*', -replace='');
		(#output >> ' ') || #output->(beginswith: '-') ? return: #id;
		#output->(replace: '%', '%25');
		#output->(replace: '&', '%26');
		#output->(replace: '+', '%2b');
		#output->(replace: '=', '%3d');
		#output->(replace: '?', '%3f');
		return: @#output;
	/define_tag;

	define_tag: 'list_cleanup', -required='input';
		local: 'output'=#input;
	
		if: #output >> '...';
			local: 'index'=#output->(find: '...');
			#output = #output->(substring: (1), (#index + 2));
		/if;
	
		return: #output;
	/define_tag;

	define_tag: 'code_highlight';
		precondition: (params)->(size) == 2;
		local: 'output'=(params)->(get:1);
	//	#output->(replace: '&nbsp;', ' ');
		local: 'tag'=(params)->(get:2);
		if: #tag->(beginswith:'-');
			#output = (string_replaceregexp: #output, -search='(' + #tag + ')(\\W)', -replace='<b>\\1</b>\\2', -ignorecase);
		else: #tag >> '->';
			local: 'index'=#tag->(find: '->');
			local: 'index2'=#tag->(find: ']');
			#tag = #tag->(substring: (#index + 2), (#index2 - #index - 2));
			#output = (string_replaceregexp: #output, -search='([>\\(;])(' + #tag + ')([:\\]\\)])', -replace='\\1<b>\\2</b>\\3', -ignorecase);
		else: #tag->(beginswith:'[');
			local: 'index'=#tag->(find: '[');
			local: 'index2'=#tag->(find: ']');
			#tag = #tag->(substring: (#index + 1), (#index2 - #index - 1));
			#output = (string_replaceregexp: #output, -search='(' + #tag + ')([:\\]\\)])', -replace='<b>\\1</b>\\2', -ignorecase);
			#output = (string_replaceregexp: #output, -search='(/' + #tag + ')([:\\]\\)])', -replace='<b>\\1</b>\\2', -ignorecase);
		/if;
	
		#output = (string_replaceregexp: #output, -search='\\r\\n|\\r|\\n', -replace='<br>', -ignorecase);	
		#output = (string_replaceregexp: #output, -search='<br>\\s+', -replace='<br>&nbsp;&nbsp;', -ignorecase);	
		#output = (string_replaceregexp: #output, -search='<\\?LassoScript', -replace='&lt;?LassoScript', -ignorecase);
		#output = (string_replaceregexp: #output, -search='<(/?a|/?form)', -replace='&lt;\\1', -ignorecase);
		
		// Also fix breaking problems in supported browsers.
		#output = (string_replaceregexp: #output, -search='(\\-[a-zA-Z]+)', -replace='<wbr><nobr>\\1</nobr>');
	
		return: #output;
	/define_tag;

?>